uniform sampler2D tex;

void main()
{
	vec4 color = texture2D(tex, gl_TexCoord[0].st);
	const float PI = 3.14159265358979323846264;
	vec3 angle = (gl_Color.rgb - vec3(0.5,0.5,0.5)) * 2.0 * PI;
	mat3 xMatrix = mat3(0,	0,				0,
						0,	cos(angle.x),	-sin(angle.x),
						0,	sin(angle.x),	cos(angle.x));
	mat3 yMatrix = mat3(cos(angle.y),	0,	sin(angle.y),
						0,				1,	0,
						-sin(angle.y),	0,	cos(angle.y));
	mat3 zMatrix = mat3(cos(angle.z),	-sin(angle.z),	0,
						sin(angle.z),	cos(angle.z),	0,
						0,				0,				1);
						
	color.rgb *= yMatrix;
	color.rgb *= xMatrix;
	color.rgb *= zMatrix;
	
	gl_FragColor = color;
}